//
// (c) 2024 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12
import QtGraphicalEffects 1.0

Item {
    id : background

    property int peakOffset : width / 2
    property color peakColor : "white"
    property bool flipped

    implicitWidth : 200
    implicitHeight : 200

    Item {
        id : content

        anchors {
            fill : background
            margins : -10
            topMargin : flipped ? -10 : -16
            bottomMargin : flipped ? -16 : -10
        }

        Rectangle {
            anchors {
                fill : content
                margins : 10
                topMargin : flipped ? 10 : 16
                bottomMargin : flipped ? 16 : 10
            }

            Item {
                anchors {
                    top :  parent.top
                }
                x : background.peakOffset
                visible : !flipped

                Rectangle {
                    anchors.centerIn : parent
                    width : 12
                    height : 12
                    rotation : 45
                    color : peakColor
                }
            }

            Item {
                anchors {
                    bottom : parent.bottom
                }
                x : background.peakOffset
                visible : flipped

                Rectangle {
                    anchors.centerIn : parent
                    width : 12
                    height : 12
                    rotation : 45
                    color : peakColor
                }
            }
        }
    }

    DropShadow {
        anchors.fill : content
        z : -1

        samples : 32
        radius : 10
        source : content
        color : "#33000000"
        cached : true
    }
}
